/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalWaterloggedBlock;
import com.mrcrayfish.furniture.tileentity.BedsideCabinetTileEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BedsideCabinetBlock
extends FurnitureHorizontalWaterloggedBlock {
    public static final BooleanProperty OPEN = BooleanProperty.func_177716_a((String)"open");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public BedsideCabinetBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] LEG_BACK_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)0.0, (double)11.0, (double)3.0, (double)2.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] LEG_FRONT_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)13.0, (double)0.0, (double)11.0, (double)15.0, (double)2.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] LEG_BACK_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)3.0), Direction.SOUTH));
        VoxelShape[] TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] HANDLE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)6.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BASE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] HANDLE_TOP_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)5.0, (double)11.0, (double)15.0, (double)11.0, (double)12.0, (double)16.0), Direction.SOUTH));
        VoxelShape[] BASE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), Direction.SOUTH));
        VoxelShape[] DRAW_TOP_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)8.0, (double)20.0, (double)16.0, (double)14.0, (double)22.0), Direction.SOUTH));
        VoxelShape[] DRAW_BOTTOM_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)8.0, (double)15.0), Direction.SOUTH));
        VoxelShape[] HANDLE_TOP_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)5.0, (double)11.0, (double)22.0, (double)11.0, (double)12.0, (double)23.0), Direction.SOUTH));
        VoxelShape[] DRAW_INSIDE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)8.0, (double)13.0, (double)15.0, (double)10.0, (double)20.0), Direction.SOUTH));
        VoxelShape[] DRAW_INSIDE_LEFT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)1.0, (double)10.0, (double)13.0, (double)3.0, (double)14.0, (double)20.0), Direction.SOUTH));
        VoxelShape[] DRAW_INSIDE_RIGHT = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)13.0, (double)10.0, (double)13.0, (double)15.0, (double)14.0, (double)20.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(LEG_BACK_LEG[direction.func_176736_b()]);
            shapes.add(LEG_FRONT_LEFT[direction.func_176736_b()]);
            shapes.add(LEG_FRONT_RIGHT[direction.func_176736_b()]);
            shapes.add(LEG_BACK_RIGHT[direction.func_176736_b()]);
            shapes.add(TOP[direction.func_176736_b()]);
            shapes.add(HANDLE_BOTTOM[direction.func_176736_b()]);
            if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
                shapes.add(BASE_OPEN[direction.func_176736_b()]);
                shapes.add(DRAW_TOP_OPEN[direction.func_176736_b()]);
                shapes.add(DRAW_BOTTOM_OPEN[direction.func_176736_b()]);
                shapes.add(HANDLE_TOP_OPEN[direction.func_176736_b()]);
                shapes.add(DRAW_INSIDE_BOTTOM[direction.func_176736_b()]);
                shapes.add(DRAW_INSIDE_LEFT[direction.func_176736_b()]);
                shapes.add(DRAW_INSIDE_RIGHT[direction.func_176736_b()]);
            } else {
                shapes.add(BASE_CLOSED[direction.func_176736_b()]);
                shapes.add(HANDLE_TOP_CLOSED[direction.func_176736_b()]);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (((Direction)state.func_177229_b((Property)DIRECTION)).func_176734_d() == result.func_216354_b()) {
            TileEntity tileEntity;
            if (!world.func_201670_d() && (tileEntity = world.func_175625_s(pos)) instanceof BedsideCabinetTileEntity) {
                playerEntity.func_213829_a((INamedContainerProvider)tileEntity);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BedsideCabinetTileEntity) {
            ((BedsideCabinetTileEntity)tileEntity).onScheduledTick();
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BedsideCabinetTileEntity();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OPEN});
    }
}

